<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 19.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName("Backup");
requireLogin();
requireRole('Administrator');
showSessionAlert();

// Backup Erstellen und Herunterladen
if (isset($_POST['backup'])) {

    $backupDir = $_SERVER['DOCUMENT_ROOT'] . '/backups';
    $uploadsDir = $_SERVER['DOCUMENT_ROOT'] . '/uploads';
    $backupFileName = 'backup_soniccg_' . date('Y-m-d_H-i-s') . '.zip';
    $zipFilePath = $backupDir . "/" . $backupFileName;
    $dbBackupFile = $backupDir . "/" . 'db_backup_' . date('Y-m-d_H-i-s') . '.sql';

    if (!is_dir($backupDir)) {
        mkdir($backupDir, 0777, true);
    }

    try {

        initializeDatabaseConnection();

        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);

        $sqlDump = '';
        foreach ($tables as $table) {
            // Struktur der Tabelle
            $createTableStmt = $pdo->query("SHOW CREATE TABLE $table")->fetch(PDO::FETCH_ASSOC);
            $sqlDump .= "\n\n" . $createTableStmt['Create Table'] . ";\n\n";

            // Daten der Tabelle
            $rows = $pdo->query("SELECT * FROM $table")->fetchAll(PDO::FETCH_ASSOC);
            foreach ($rows as $row) {
                $sqlDump .= "INSERT INTO `$table` VALUES(";

                $rowValues = array_map(function ($value) use ($pdo) {
                    if (is_null($value)) {
                        return "NULL"; // Behandle NULL explizit
                    }
                    return $pdo->quote($value);
                }, $row);

                $sqlDump .= implode(", ", $rowValues);
                $sqlDump .= ");\n";
            }
            $sqlDump .= "\n";
        }

        // Speichere die Dump-Datei
        file_put_contents($dbBackupFile, $sqlDump);

        $zip = new ZipArchive();
        if ($zip->open($zipFilePath, ZipArchive::CREATE) === TRUE) {

            $zip->addFile($dbBackupFile, basename($dbBackupFile));

            $files = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($uploadsDir),
                RecursiveIteratorIterator::LEAVES_ONLY
            );

            foreach ($files as $file) {
                if (!$file->isDir()) {
                    $filePath = $file->getRealPath();
                    $relativePath = substr($filePath, strlen($uploadsDir));
                    $zip->addFile($filePath, 'uploads/' . $relativePath);
                }
            }

            $zip->close();

            unlink($dbBackupFile);

            if (file_exists($zipFilePath)) {
                header('Content-Type: application/zip');
                header('Content-Disposition: attachment; filename="' . basename($zipFilePath) . '"');
                header('Content-Length: ' . filesize($zipFilePath));

                readfile($zipFilePath);

                unlink($zipFilePath);

                addAuditLog($_SESSION['Username'], 'Backup', 'Backup Heruntergeladen');

            } else {
                createSessionAlert("", "Fehler beim Erstellen der ZIP-Datei", "error", "false", "2000");
                header('Location: ' . $_SERVER['PHP_SELF']);
                exit();
            }
        } else {
            createSessionAlert("", "Fehler beim Erstellen des ZIP-Archivs", "error", "false", "2000");
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit();
        }
    } catch (PDOException $e) {
        createSessionAlert("", "Fehler beim Zugriff auf die Datenbank: " . $e->getMessage(), "error", "false", "2000");
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Backup</h4>
        <span class="text-secondary">Administration</span>
    </div>
</div>

<div class="row">

    <div class="col-lg-12 col-xl-8 grid-margin stretch-card">
        <div class="card">
            <div class="card-header">
                Backup
            </div>
            <div class="card-body">
                Hier haben Sie die Möglichkeit, ein vollständiges Backup aller relevanten Daten des Systems
                herunterzuladen. <br>Dieses Backup umfasst:

                <ul class="mt-3 mb-5 list-group">
                    <li class="list-group-item">
                        <h6 class="mb-1">Datenbank:</h6>Eine vollständige Sicherung der Sonic Camp Guard-Datenbank.
                        Diese enthält sämtliche wichtige Informationen und Systemdaten, die zur Verwaltung und
                        Überwachung des Camps benötigt werden. Die Datenbank wird als <span
                            class="badge bg-secondary">.sql</span>-Datei exportiert, um eine einfache Wiederherstellung
                        zu gewährleisten.
                    </li>
                    <li class="list-group-item">
                        <h6 class="mb-1">Uploads:</h6>Der komplette Inhalt des <span
                            class="badge bg-secondary">/uploads/</span> Ordners, der alle hochgeladenen Dateien, wie
                        Berichte, Bilder und andere Dokumente, enthält, die während des Betriebs des Systems gespeichert
                        wurden.
                    </li>
                </ul>

                <form action="" method="POST">
                    <button type="submit" class="btn btn-primary btn-icon-text" name="backup">
                        <i class="btn-icon-prepend mdi mdi-download"></i>
                        Herunterladen
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-4 grid-margin">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Hinweise
            </div>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">Das Backup wird als ZIP-Datei bereitgestellt, die sowohl die Datenbank- als
                    auch die hochgeladenen Dateien enthält.</li>
                <li class="list-group-item">Nach dem Klicken auf den "Herunterladen"-Button wird die ZIP-Datei generiert
                    und automatisch auf Ihr Gerät heruntergeladen.</li>
                <li class="list-group-item"><b>Sicherheitstipp:</b> Bewahren Sie diese Datei sicher auf, da sie wichtige
                    Daten enthält. Laden Sie die Datei nur auf sichere Speicherorte herunter.</li>
                <li class="list-group-item">Für Fragen oder Unterstützung bei der Wiederherstellung Ihres Backups wenden
                    Sie sich bitte an den Ansprechpartner, der im Impressum aufgeführt ist.</li>
            </ul>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>